﻿/*
VERSION:	1.0

USAGE:
	#include "makeGrayscale.as"
	grayImage_pic = makeGrayscale( colorImage_pic );
	
NOTE:
	This effect is VERY slow!
	It took 5.133 seconds to affect Miyamoto.  (averaged measurement from 4 tries)
	(Fastest possible time with Zero processing is:  0.248 seconds)
*/



makeGrayscale = function( input_pic )
{
	// copy the image
	var output_pic = input_pic.clone();
	
	
	for (var y = 0; y < output_pic.height; ++y)
	{
		for (var x = 0; x < output_pic.width; ++x)
		{
			// read color
			var colorHex = output_pic.getPixel(x, y).toString(16);
			if (colorHex.length == 5)
			{
				colorHex = "0" + colorHex;
			}
			
			// read RGB of this color
			var redNum = 0;
			var greenNum = 0;
			var blueNum = 0;
			if (colorHex.length == 6)
			{
				var redHex = colorHex.substring(0, 2);
				redNum = parseInt(redHex, 16);
			} 
			if (colorHex.length >= 4)
			{
				greenHex = colorHex.substring(2, 4);
				greenNum = parseInt(greenHex, 16);
			}
			if (colorHex.length >= 2)
			{
				blueHex = colorHex.substring(4, 6);
				blueNum = parseInt(blueHex, 16);
			}
			
			// find average gray tone
			var averageColorNum = (redNum + greenNum + blueNum) / 3;
			
			// construct hex color
			var averageColorHex = averageColorNum.toString(16);
			if (averageColorHex.length == 1)
			{
				averageColorHex = "0" + averageColorHex;
			}
			var grayColorHex = averageColorHex + averageColorHex + averageColorHex + averageColorHex + averageColorHex + averageColorHex;
			averageColorNum = parseInt(grayColorHex, 16);
			
			// write gray pixel
			output_pic.setPixel(x, y, averageColorNum);
		}// for:  x
	}// for:  y
	
	
	return output_pic;
}// makeGrayscale()